// GTDevmonSampleDlg.h : Header file.
//

#if !defined(AFX_GTDEVMONSAMPLEDLG_H__B1E16632_D2B1_4B86_B2C4_466DEEF7F0EC__INCLUDED_)
#define AFX_GTDEVMONSAMPLEDLG_H__B1E16632_D2B1_4B86_B2C4_466DEEF7F0EC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// Input Value
#define INPUTVAL_MAX			(32767)
#define INPUTVAL_MIN			(-32768)

// Device ID No.
#define GB_DEV_ID				(0)
#define GD_DEV_ID				(1)
#define	GS_DEV_ID				(2)

// Return Value
#define	GDEV_OK					(0)
#define	GDEV_ERR_DEV_NAME_ID	(-1)
#define	GDEV_ERR_DEV_MIN_NUM	(-2)
#define	GDEV_ERR_DEV_MAX_NUM	(-3)
#define	GDEV_ERR_MAPPOINTER		(-9)

/////////////////////////////////////////////////////////////////////////////
// CGTDevmonSampleDlg Dialog.

class CGTDevmonSampleDlg : public CDialog
{
// Construction.
public:
	CGTDevmonSampleDlg(CWnd* pParent = NULL);	// Standard constructor.

	BOOL	PreTranslateMessage(MSG* pMsg);
	void	GBDevAccess(bool flag);
	void	GTDeviceRangeCheck(unsigned int EdiCtrlId,unsigned int SpnCtrlId);
	ULONG	CGTDevmonSampleDlg::GTDeviceRangeCorrect(UINT EdiCtrlId, UINT SpnCtrlId, LONG SetValue);

// Dialog data.
	//{{AFX_DATA(CGTDevmonSampleDlg)
	enum { IDD = IDD_GTDEVMONSAMPLE_DIALOG };
	CButton			m_MonStartCap;
	UINT			m_uiGD_Dev_Num;
	UINT			m_uiGB_Dev_Num;
	UINT			m_uiGS_Dev_Num;
	HANDLE			m_hDev_MapFile;
	ULONG			m_ulDev_MapPointer;
	BOOL			m_bDevMoniFlag;
	int		m_iGD_Write_Val;
	int		m_iGS_Write_Val;
	//}}AFX_DATA

	// ClassWizard generates the override of a virtual function.
	//{{AFX_VIRTUAL(CGTDevmonSampleDlg)
	protected:
	virtual	void	DoDataExchange(CDataExchange* pDX);	// Support of DDX/DDV.
	//}}AFX_VIRTUAL

// Implementation.
protected:
	HICON			m_hIcon;
	CToolTipCtrl	m_ToolTip;
	CStatusBar		m_StatusBar;

	// Generated message map function.
	//{{AFX_MSG(CGTDevmonSampleDlg)
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnGdWriteBtn();
	afx_msg void OnGbOnBtn(){GBDevAccess(true);}
	afx_msg void OnGbOffBtn(){GBDevAccess(false);}
	afx_msg void OnGsWriteBtn();
	afx_msg void OnMonStartBtn();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnClose(){OnCancel();}
	afx_msg void OnKillfocusGbEdit(){GTDeviceRangeCheck(IDC_GB_EDIT,IDC_GB_SPIN);}
	afx_msg void OnKillfocusGdEdit(){GTDeviceRangeCheck(IDC_GD_EDIT,IDC_GD_SPIN);}
	afx_msg void OnKillfocusGsEdit(){GTDeviceRangeCheck(IDC_GS_EDIT,IDC_GS_SPIN);}
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ inserts the declaration of the addition just before the former line.

#endif // !defined(AFX_GTDEVMONSAMPLEDLG_H__B1E16632_D2B1_4B86_B2C4_466DEEF7F0EC__INCLUDED_)
